/*
 * Decompiled with CFR 0.152.
 */
import org.lwjgl.input.Keyboard;

public class TMIView {
    private _tmi_MgCanvas canvas;
    private TMIConfig config;
    private TMIController controller;
    private boolean widgetsCreated = false;
    private _tmi_MgButton prevButton;
    private _tmi_MgButton nextButton;
    private _tmi_MgButton trashButton;
    private _tmi_MgButton[] stateButtons;
    private _tmi_MgButton[] deleteButtons;
    public _tmi_MgItemPanel itemPanel;

    public TMIView(_tmi_MgCanvas _tmi_MgCanvas2, TMIConfig tMIConfig, TMIController tMIController) {
        this.canvas = _tmi_MgCanvas2;
        this.config = tMIConfig;
        this.controller = tMIController;
        this.stateButtons = new _tmi_MgButton[this.config.getNumSaves()];
        this.deleteButtons = new _tmi_MgButton[this.config.getNumSaves()];
        this.createWidgets();
    }

    public void createWidgets() {
        this.prevButton = new _tmi_MgButton("Prev", this.controller, "prev");
        this.canvas.widgets.add(this.prevButton);
        this.nextButton = new _tmi_MgButton("Next", this.controller, "next");
        this.canvas.widgets.add(this.nextButton);
        this.itemPanel = new _tmi_MgItemPanel(0, 0, 0, 0, 0, this.config.getItems(), this.controller);
        this.canvas.widgets.add(this.itemPanel);
        if (!TMIConfig.isMultiplayer()) {
            this.trashButton = new _tmi_MgButton("Trash", this.controller, "trash");
            this.canvas.widgets.add(this.trashButton);
            this.stateButtons = new _tmi_MgButton[this.config.getNumSaves()];
            for (int i2 = 0; i2 < this.config.getNumSaves(); ++i2) {
                this.stateButtons[i2] = new _tmi_MgButton("Save " + (i2 + 1), this.controller, new TMIStateButtonData(i2, 0));
                this.canvas.widgets.add(this.stateButtons[i2]);
                this.deleteButtons[i2] = new _tmi_MgButton("x", this.controller, new TMIStateButtonData(i2, 1));
                this.canvas.widgets.add(this.deleteButtons[i2]);
            }
        }
        this.widgetsCreated = true;
    }

    public void layout(int n2, int n3, int n4, int n5) {
        if (!this.widgetsCreated) {
            this.createWidgets();
        }
        this.prevButton.x = (n4 + n2) / 2;
        this.prevButton.y = 0;
        this.prevButton.width = this.canvas.windowX;
        this.prevButton.height = 28;
        this.nextButton.x = (n4 + n2) / 2;
        this.nextButton.y = n3 - 28;
        this.nextButton.width = this.canvas.windowX;
        this.nextButton.height = 28;
        this.itemPanel.x = (n2 + n4) / 2 + 5;
        this.itemPanel.y = 30;
        this.itemPanel.width = n2 - 5 - this.itemPanel.x;
        this.itemPanel.height = n3 - 30 - this.itemPanel.y;
        this.itemPanel.resize();
        this.prevButton.label = "Prev (" + (_tmi_MgItemPanel.page + 1) + "/" + this.itemPanel.numPages + ")";
        if (!TMIConfig.isMultiplayer()) {
            int n6;
            this.trashButton.x = 0;
            this.trashButton.y = n3 - 30;
            this.trashButton.width = 82;
            this.trashButton.height = 30;
            this.trashButton.label = TMIUtils.getHeldItem() == null && (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) ? "Delete all" : "Trash";
            int n7 = 0;
            for (n6 = 0; n6 < this.config.getNumSaves(); ++n6) {
                this.deleteButtons[n6].x = -1000;
                this.stateButtons[n6].y = 30 + n6 * 22;
                this.stateButtons[n6].height = 20;
                String string = this.config.getSettings().get("save-name" + (n6 + 1));
                if (string == null) {
                    string = "" + (n6 + 1);
                }
                this.stateButtons[n6].label = this.config.isStateSaved(n6) ? "Load " + string : "Save " + string;
                int n8 = this.canvas.getTextWidth(this.stateButtons[n6].label) + 26;
                if (n8 + 2 + 20 > this.canvas.windowX) {
                    n8 = this.canvas.windowX - 20 - 2;
                }
                if (n8 <= n7) continue;
                n7 = n8;
            }
            for (n6 = 0; n6 < this.config.getNumSaves(); ++n6) {
                this.stateButtons[n6].width = n7;
                if (!this.config.isStateSaved(n6)) continue;
                this.deleteButtons[n6].x = this.stateButtons[n6].width + 2;
                this.deleteButtons[n6].y = this.stateButtons[n6].y;
                this.deleteButtons[n6].width = 20;
                this.deleteButtons[n6].height = 20;
            }
        }
    }

    public void showToolTip(int n2, int n3) {
        if (!TMIConfig.isMultiplayer() && this.trashButton.contains(n2, n3)) {
            if (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) {
                if (TMIUtils.getHeldItem() == null) {
                    this.canvas.drawTip(n2, n3, "Delete ALL items from current inventory screen");
                } else {
                    this.canvas.drawTip(n2, n3, "Delete ALL " + TMIUtils.itemDisplayName(TMIUtils.getHeldItem()));
                }
            } else if (TMIUtils.getHeldItem() == null) {
                this.canvas.drawTip(n2, n3, "Drop item here to delete");
            } else {
                this.canvas.drawTip(n2, n3, "Delete " + TMIUtils.itemDisplayName(TMIUtils.getHeldItem()));
            }
        }
    }

    public boolean isInitialized() {
        return this.widgetsCreated;
    }
}

