/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;

public class TMIUtils {
    public static final String CONFIG_FILENAME = "TooManyItems.txt";

    public static Minecraft getMinecraft() {
        try {
            Field field = Minecraft.class.getDeclaredField("a");
            field.setAccessible(true);
            return (Minecraft)field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        return null;
    }

    public static void loadPreferences(TMIConfig tMIConfig) {
        try {
            Map<String, String> map = tMIConfig.getSettings();
            File file = new File(Minecraft.a("minecraft"), CONFIG_FILENAME);
            if (file.exists()) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(":", 2);
                    if (stringArray.length <= 1 || !map.containsKey(stringArray[0])) continue;
                    map.put(stringArray[0], stringArray[1]);
                }
                bufferedReader.close();
                for (int i2 = 0; i2 < tMIConfig.getNumSaves(); ++i2) {
                    tMIConfig.decodeState(i2, map.get("save" + (i2 + 1)));
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void savePreferences(TMIConfig tMIConfig) {
        try {
            Map<String, String> map = tMIConfig.getSettings();
            File file = new File(Minecraft.a("minecraft"), CONFIG_FILENAME);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (String string : map.keySet()) {
                printWriter.println(string + ":" + map.get(string));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void loadItems(TMIConfig tMIConfig) {
        List<iz> list = tMIConfig.getItems();
        list.clear();
        for (gm gm2 : gm.c) {
            if (gm2 == null) continue;
            if (!TMIConfig.isItemIncluded(gm2.bf)) continue;
            HashSet<String> hashSet = new HashSet<String>();
            int n2 = tMIConfig.areDamageVariantsShown() ? 15 : 0;
            for (int i2 = 0; i2 <= n2; ++i2) {
                iz iz2 = new iz(gm2, gm2.d(), i2);
                try {
                    int n3 = gm2.b(iz2);
                    String string = iz2.l() + "@" + n3;
                    if (hashSet.contains(string)) continue;
                    list.add(iz2);
                    hashSet.add(string);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    public static void safeReportException(Exception exception) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(".yyyyMMdd.HHmmss");
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(1));
            String string = "tmi" + stringBuffer.toString() + ".txt";
            File file = new File(Minecraft.a("minecraft"), string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print("[code]TMI Version: 1.7.2 2011-07-01\n");
            exception.printStackTrace(printWriter);
            printWriter.println("[/code]");
            printWriter.close();
            TMIUtils.getMinecraft().v.a("Error written to " + string);
        }
        catch (Exception exception2) {
            System.out.println("Error during safeReportException:");
            exception2.printStackTrace();
        }
    }

    public static String itemDisplayName(iz iz2) {
        try {
            String string = nh.a().b(iz2.l());
            if (!string.trim().equals("")) {
                return string;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "Unnamed";
    }

    public static boolean isValidItem(iz iz2) {
        return iz2 == null || iz2.c >= 0 && iz2.c < gm.c.length && gm.c[iz2.c] != null;
    }

    public static iz getValidItem(iz iz2) {
        if (TMIUtils.isValidItem(iz2)) {
            return iz2;
        }
        return new iz(uu.as);
    }

    public static String getValidItemDisplayName(iz iz2) {
        if (TMIUtils.isValidItem(iz2)) {
            return TMIUtils.itemDisplayName(iz2);
        }
        return "Undefined Item";
    }

    public static void deleteHeldItem() {
        TMIUtils.getMinecraft().h.c.b((iz)null);
    }

    public static iz getHeldItem() {
        return TMIUtils.getMinecraft().h.c.i();
    }

    public static void giveStack(iz iz2, TMIConfig tMIConfig) {
        TMIUtils.giveStack(iz2, tMIConfig, iz2.a);
    }

    public static void giveStack(iz iz2, TMIConfig tMIConfig, int n2) {
        iz iz3 = TMIUtils.copyStack(iz2, n2);
        Minecraft minecraft = TMIUtils.getMinecraft();
        if (TMIConfig.isMultiplayer()) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(false);
            MessageFormat messageFormat = new MessageFormat(tMIConfig.getSettings().get("give-command"));
            messageFormat.setFormatByArgumentIndex(1, numberFormat);
            messageFormat.setFormatByArgumentIndex(2, numberFormat);
            messageFormat.setFormatByArgumentIndex(3, numberFormat);
            Object[] objectArray = new Object[]{minecraft.h.l, iz3.c, iz3.a, iz3.i()};
            minecraft.h.a(messageFormat.format(objectArray));
        } else {
            minecraft.h.c.a(iz3);
        }
    }

    public static iz copyStack(iz iz2, int n2) {
        if (iz2 == null) {
            return null;
        }
        iz2.a += n2;
        return iz2.a(n2);
    }

    public static iz copyStack(iz iz2) {
        if (iz2 == null) {
            return null;
        }
        return TMIUtils.copyStack(iz2, iz2.a);
    }

    public static void updateUnlimitedItems() {
        if (TMIConfig.isMultiplayer() || !TMIConfig.getInstance().isEnabled()) {
            return;
        }
        for (iz iz2 : TMIUtils.getMinecraft().h.c.a) {
            if (iz2 == null) continue;
            if (iz2.a < 0 || iz2.a > 64) {
                iz2.a = 111;
            }
            if (iz2.i() >= 0) continue;
            TMIUtils.setStackDamage(iz2, -32000);
        }
        iz iz3 = TMIUtils.getHeldItem();
        if (iz3 != null && iz3.a > 64) {
            iz3.a = -1;
        }
    }

    public static void setStackDamage(iz iz2, int n2) {
        try {
            for (Field field : iz.class.getDeclaredFields()) {
                if (!field.getName().equals("d")) continue;
                field.setAccessible(true);
                field.setInt(iz2, n2);
                break;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

