/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIConfig {
    public static final String VERSION = "1.7.2 2011-07-01";
    public static final int NUM_SAVES = 7;
    public static final int INVENTORY_SIZE = 44;
    public static boolean isModloaderEnabled;
    private static TMIConfig instance;
    private static List<iz> items;
    private static HashSet<Integer> toolIds;
    private static HashSet<Integer> nonUnlimitedIds;
    private Map<String, String> settings = new LinkedHashMap<String, String>();
    private static iz[][] states;
    private static boolean[] statesSaved;
    private static HashSet<Integer> excludeIds;

    public TMIConfig() {
        int n2;
        this.settings.put("enable", "true");
        this.settings.put("enablemp", "false");
        this.settings.put("give-command", "/give {0} {1} {2}");
        for (n2 = 0; n2 < this.getNumSaves(); ++n2) {
            this.settings.put("save-name" + (n2 + 1), "" + (n2 + 1));
        }
        for (n2 = 0; n2 < this.getNumSaves(); ++n2) {
            this.settings.put("save" + (n2 + 1), "");
        }
        instance = this;
    }

    public static boolean isMultiplayer() {
        return TMIUtils.getMinecraft().f.B;
    }

    public static TMIConfig getInstance() {
        if (instance == null) {
            new TMIConfig();
        }
        return instance;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public List<iz> getItems() {
        return items;
    }

    public int getNumSaves() {
        return 7;
    }

    public boolean isStateSaved(int n2) {
        return statesSaved[n2];
    }

    public iz[] getState(int n2) {
        return states[n2];
    }

    public boolean getBooleanSetting(String string) {
        return Boolean.parseBoolean(this.settings.get(string));
    }

    public boolean isEnabled() {
        return TMIConfig.isMultiplayer() && this.getBooleanSetting("enablemp") || !TMIConfig.isMultiplayer() && this.getBooleanSetting("enable");
    }

    public void toggleEnabled() {
        String string = TMIConfig.isMultiplayer() ? "enablemp" : "enable";
        this.settings.put(string, Boolean.toString(!this.getBooleanSetting(string)));
    }

    public void setEnabled(boolean bl2) {
        String string = TMIConfig.isMultiplayer() ? "enablemp" : "enable";
        this.settings.put(string, Boolean.toString(bl2));
    }

    public static boolean isItemIncluded(int n2) {
        return !excludeIds.contains(n2);
    }

    public static boolean isTool(gm gm2) {
        return toolIds.contains(gm2.bf);
    }

    public static boolean canItemBeUnlimited(gm gm2) {
        return !nonUnlimitedIds.contains(gm2.bf);
    }

    public boolean areDamageVariantsShown() {
        if (TMIConfig.isMultiplayer()) {
            String string = this.getSettings().get("give-command");
            return string.contains("{3}");
        }
        return true;
    }

    public void clearState(int n2) {
        for (int i2 = 0; i2 < 44; ++i2) {
            TMIConfig.states[n2][i2] = null;
            TMIConfig.statesSaved[n2] = false;
        }
        this.settings.put("save" + (n2 + 1), "");
    }

    public void loadState(int n2) {
        if (!statesSaved[n2]) {
            return;
        }
        List list = TMIUtils.getMinecraft().h.d.e;
        for (int i2 = 0; i2 < 44; ++i2) {
            gp gp2 = (gp)list.get(i2 + 1);
            gp2.c(null);
            iz iz2 = TMIUtils.copyStack(states[n2][i2]);
            if (iz2 == null || iz2.c < 0 || iz2.c >= gm.c.length || gm.c[iz2.c] == null) continue;
            gp2.c(iz2);
        }
    }

    public void saveState(int n2) {
        List list = TMIUtils.getMinecraft().h.d.e;
        for (int i2 = 0; i2 < 44; ++i2) {
            TMIConfig.states[n2][i2] = TMIUtils.copyStack(((gp)list.get(i2 + 1)).a());
        }
        this.settings.put("save" + (n2 + 1), this.encodeState(n2));
        TMIConfig.statesSaved[n2] = true;
    }

    public String encodeState(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 44; ++i2) {
            if (states[n2][i2] != null) {
                stringBuilder.append(TMIConfig.states[n2][i2].c);
                stringBuilder.append(":");
                stringBuilder.append(TMIConfig.states[n2][i2].a);
                stringBuilder.append(":");
                stringBuilder.append(states[n2][i2].i());
            }
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public void decodeState(int n2, String string) {
        if (string.trim().equals("")) {
            TMIConfig.statesSaved[n2] = false;
        } else {
            String[] stringArray = string.split(",", 0);
            for (int i2 = 0; i2 < stringArray.length && i2 < states[n2].length; ++i2) {
                String[] stringArray2 = stringArray[i2].split(":");
                if (stringArray2.length != 3) continue;
                try {
                    TMIConfig.states[n2][i2] = new iz(Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]));
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            TMIConfig.statesSaved[n2] = true;
        }
    }

    static {
        int n2;
        isModloaderEnabled = false;
        items = new ArrayList<iz>();
        toolIds = new HashSet();
        for (n2 = 1; n2 <= 3; ++n2) {
            toolIds.add(n2 + 256);
        }
        for (n2 = 11; n2 <= 23; ++n2) {
            toolIds.add(n2 + 256);
        }
        for (n2 = 27; n2 <= 30; ++n2) {
            toolIds.add(n2 + 256);
        }
        for (n2 = 42; n2 <= 61; ++n2) {
            toolIds.add(n2 + 256);
        }
        nonUnlimitedIds = new HashSet();
        nonUnlimitedIds.add(358);
        states = new iz[7][44];
        statesSaved = new boolean[7];
        excludeIds = new HashSet();
        excludeIds.add(9);
        excludeIds.add(11);
        excludeIds.add(63);
        excludeIds.add(64);
        excludeIds.add(68);
        excludeIds.add(71);
        excludeIds.add(74);
        excludeIds.add(75);
        excludeIds.add(59);
        excludeIds.add(83);
        excludeIds.add(55);
        excludeIds.add(26);
        excludeIds.add(93);
        excludeIds.add(94);
    }
}

